#! /usr/bin/perl

use strict;
use warnings;
use CGI qw/:standard/;
use CGI::FormBuilder;
use Data::Uniqid qw ( luniqid );

my $page=CGI->new;
my $uuid=luniqid;

print   $page->header,
	$page->start_html( -title=>'Secure Acceptance - Payment Form Example', -style=>'payment.css', -script=>[ { -type=>'text/javascript', -src=>'jquery-1.7.min.js' }, { -type=>'text/javascript', -src=>'payment_form.js' } ] );
	
	my $form=CGI::FormBuilder->new( id=>'payment_form', stylesheet => 'payment.css', action=>'payment_confirmation.cgi', method=>'post', submit=>[ 'Submit'  ], fieldsets=>[ [ paymentDetails => "Payment Details" ] ]);
		$form->field( name=>"access_key", type=>"hidden", value=>"<REPLACE WITH ACCESS KEY>" );
		$form->field( name=>"profile_id", type=>"hidden", value=>"<REPLACE WITH PROFILE ID>" );
		$form->field( name=>"transaction_uuid", type=>"hidden", value=>$uuid);
		$form->field( name=>"signed_field_names", type=>"hidden", value=>"access_key,profile_id,transaction_uuid,signed_field_names,unsigned_field_names,signed_date_time,locale,transaction_type,reference_number,amount,currency");
		$form->field( name=>"unsigned_field_names", type=>"hidden" );
		$form->field( name=>"signed_date_time", type=>"hidden", value=>&get_date_time() );
		$form->field( name=>"locale", type=>"hidden", value=>"en" );
		$form->field( name=>"transaction_type", size=>"25", label=>"transaction_type: ", fieldset=>"paymentDetails" );
		$form->field( name=>"reference_number", size=>"25", label=>"reference_number: ", fieldset=>"paymentDetails" );
		$form->field( name=>"amount", size=>"25", label=>"amount: ", fieldset=>"paymentDetails" );
		$form->field( name=>"currency", size=>"25", label=>"currency: ", fieldset=>"paymentDetails" );

print $form->render();
print $page->end_html;

sub get_date_time() {
	my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = gmtime();	
	my $year = 1900 + $yearOffset;
	$month=&ensureTwoDigits( ++$month );
	$dayOfMonth=&ensureTwoDigits( $dayOfMonth );
	$hour=&ensureTwoDigits( $hour );
	$minute=&ensureTwoDigits( $minute );
	$second=&ensureTwoDigits( $second );	
	return "$year-$month-$dayOfMonth"."T"."$hour:$minute:$second"."Z";
}

sub ensureTwoDigits {
	my $number=$_[0];
	$number="0".$number if $number < 10;
	return $number;
}


