#! /usr/bin/perl

use strict;
use warnings;
use CGI qw/:standard/;
use CGI::FormBuilder;
require 'security.pl';

my $page=CGI->new;
my $form=CGI::FormBuilder->new( id=>'payment_confirmation', action=>'https://testsecureacceptance.cybersource.com/pay', method=>'post', submit=> [ 'Confirm' ] );

print   $page->header,
	$page->start_html( -title=>'Secure Acceptance - Payment Form Example', -style=>"payment.css" );

	my %payment_form_data = $page->Vars;
	my @signed_field_names = split(',', $payment_form_data{ 'signed_field_names' } );
	my $signed_data = &sign( \%payment_form_data, \@signed_field_names );
	$form->field( name=>"signature", type=>"hidden", value=>"$signed_data" );

	my @fields=();
	foreach ( @signed_field_names ) {
		my $name=$_;
		my $value=$payment_form_data{$_};
		push( @fields, $page->div( $page->span( { -class=>'fieldName' }, "$name" ), $page->span( { -class=>'fieldValue' }, "$value" ) )."\n" );
		$form->field( name=>"$name", type=>"hidden", value=>"$value" );		
	}

print   $page->fieldset( $page->legend( "Review Payment Details" ), $page->div( @fields ) );		
print   $form->render();
print   $page->end_html;
